/*
   This program adds two numbers and writes the result to standard output.

   The default values for the two numbers are 0 and 0.
   These default values can be overridden by
      1.) values from a configuration file, or by
      2.) environment variables, or by
      3.) command line arguments.
*/
#include <stdlib.h>
#include <stdio.h>

#define  LINELEN  64

int main(int argc, char *argv[])
{
   char oneLine[LINELEN];

   // Set the default values.
   int x1 = 0;
   int x2 = 0;

   // Override the default values with values from the configuration file.
   // open the configuration file
   FILE * fp;
   if ( (fp = fopen("adder.cfg","r")) == NULL )
   {
      perror("Failed to open config file");
   }
   // read the first line of the config file
   if ( fgets(oneLine, LINELEN, fp) )
   {
      // get an operand from the config file
      x1 = atoi(oneLine);
      // read the second line of the config file
      if ( fgets(oneLine, LINELEN, fp) )
      {
         // get an operand from the config file
         x2 = atoi(oneLine);
      }
   }


   // Override the default values with environment variable values.
   char *op1 = getenv( "adder-op1" );
   if (op1 != NULL )
   {  // get an operand from the environment
      x1 = atoi(op1);
   }

   char *op2 = getenv( "adder-op2" );
   if (op2 != NULL )
   {  // get an operand from the environment
      x2 = atoi(op2);
   }


   // Get the command line arguments (if they exist).
   if (argc > 1)
   {  // get an operand from the command line
      x1 = atoi(argv[1]);
   }

   if (argc > 2)
   {  // get an operand from the command line
       x2 = atoi(argv[2]);
   }

   // write the result to standard out
   printf("%d", x1 + x2);

   return 0;
}
